/*-------------------------------------------------------*
*  Name:      BIN Filter for ZModeler v1.06              *
*  Purpose:   Microsoft Monster trucks madness 1,2       *
*  Authors:   Oleg M. MIN file format and filter source  *
*             code was provided by AntiDMCA              *
*             <antiDMCA@hotmail.com>                     *
*  History:   23.Mar.2002 - rebuild for ZModeler v1.06   *
*             16.Sep.2001 - rebuild for ZModeler v1.05   *
*                                                        *
*-------------------------------------------------------*/
#include <Struct.h>
#include <3DEngine.h>

#include "bin.h"
#include "faceref.h"

DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}

//////////////////////////////////////////////////////////////
//  DWORD Supports returns a combination of supported features
DWORD CALLBACK Supports(DWORD)
{
  return Z3D_PLUGSUPPORTS_IMPORT | Z3D_PLUGSUPPORTS_EXPORT;
}

//////////////////////////////////////////////////////////////
//  DWORD DynamicLoading specifies whether the dll will be
//  loaded only when it'sfunctions are needed.
//  You should NOT make it dynamic, if it is a processor-type.
DWORD CALLBACK DynamicLoading(DWORD)
{
  return 1L; // DLL will be loaded each time it is needed
}

//////////////////////////////////////////////////////////////
//  char* GetFilterExtension returns a file extention for sup-
//  ported files. Used if it is an IMPORT/EXPORT type
char* CALLBACK GetFilterExtension(DWORD)
{
  return "bin";
}

//////////////////////////////////////////////////////////////
//  char* GetFilterMask returns a file-mask for CFileDilaog.
//  Used if it is an IMPORT/EXPORT type.
char* CALLBACK GetFilterMask(DWORD)
{
  return "BIN 3D meshes (*.bin)|*.bin|";
}


//////////////////////////////////////////////////////////////
//  Shows a failure message.
void _stdcall ShowFailMessage(CWnd* pwnd, char *errmsg, char *cause, UINT icon)
{
  char str[512];
  strcpy(str, "Error importing/exporting file: ");
  strcat(str, errmsg);
  strcat(str, "\nPossible caused by: ");
  strcat(str, cause);
  pwnd->MessageBox(str,"Filter message:", icon);
}


//////////////////////////////////////////////////////////////
//  Creates a BMP file from TGA file. (Textures)
CString _stdcall CreateBMPFromRAW(CWnd* pwnd, CString FileName)
{
  CFile InFile, OutFile, PalFile;
  CString OutName = FileName.Left(FileName.GetLength()-4)+".bmp";
  CString PalName = FileName.Left(FileName.GetLength()-4)+".act";
  OutName = OutName.Right(OutName.GetLength() - OutName.ReverseFind('\\') - 1);

  if (!InFile.Open(FileName, CFile::modeRead) ||
    !PalFile.Open(PalName, CFile::modeRead) ||
    !OutFile.Open(OutName, CFile::modeWrite | CFile::modeCreate))
  {
    ShowFailMessage(pwnd, FileName.GetBuffer(32), "Missing this file or according PAL/ACT file.", MB_ICONEXCLAMATION);
    OutName = "";
    return OutName;
  }

  WORD width;
  WORD height;

  if (InFile.GetLength()==256*256)
  {
    width = 256;
    height= 256;
  }
  else
  if (InFile.GetLength()==128*128)
  {
    width = 128;
    height= 128;
  }
  else
  if (InFile.GetLength()==64*64)
  {
    width = 64;
    height= 64;
  }
  else
  if (InFile.GetLength()==32*32)
  {
    width = 32;
    height= 32;
  }
  else
  if (InFile.GetLength()==16*16)
  {
    width = 16;
    height= 16;
  }

  long filesize = 0x0438+InFile.GetLength();
  BYTE buf[54] = {
          //0x42,0x4d,0x38,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,//16
          0x42,0x4d, (BYTE)(filesize&0xFF),(BYTE)((filesize&0xFF00)>>8),(BYTE)((filesize&0xFF0000)>>16),(BYTE)((filesize&0xFF000000)>>24),0x00,0x00,0x00,0x00,0x36,0x04,0x00,0x00,0x28,0x00,//16
          //0x00,0x00, sizes[0],sizes[1],0x00, 0x00,sizes[2],sizes[3],0x00,0x00, 0x01, 0x00,0x18,0x00,0x00,0x00,//16
          0x00,0x00, (BYTE)(width&0xFF), (BYTE)((width&0xFF00)>>8), 0x00, 0x00, (BYTE)(height&0xFF), (BYTE)((height&0xFF00)>>8), 0x00,0x00, 0x01, 0x00,0x08,0x00,0x00,0x00,//16
          0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x0B,0x00,0x00,0x12,0x0B,0x00,0x00,0x00,0x00,//16
          0x00,0x00,0x00,0x00,0x00,0x00};//6
  OutFile.Write(buf, 54);

  int j=0,i;
  BYTE tmp;
  BYTE *in = new BYTE[InFile.GetLength()];
  BYTE *pal= new BYTE[768];
  InFile.ReadHuge(in, InFile.GetLength());
  PalFile.ReadHuge(pal, 768);

  //Backwarding image
  long size = width*height;
  for (i = 0; i < size/2; i++)
  {
    tmp=in[i];
    j = ((size-i-1)/width)*width + (i%width);
    in[i] = in[j];
    in[j] = tmp;
  }
  j=0;

  BYTE zero = 0;
  for (i = 0; i < 256; i++)
  {
    OutFile.Write(&pal[i*3+2], 1);
    OutFile.Write(&pal[i*3+1], 1);
    OutFile.Write(&pal[i*3], 1);
    OutFile.Write(&zero, 1);
  }
  OutFile.WriteHuge(in, InFile.GetLength());

  
  InFile.Close();
  PalFile.Close();
  OutFile.Close();
  delete[] in;
  delete[] pal;

  return OutName;
}


void SetFace(tFace *pface, FaceList* pList, sFaceData* pData, sFaceHeader* pDesc, DWORD type)
{
/*
  pface->I1 = pData[0].index;
  pface->U1 = (float)(pData[0].u & 0xFF)/255.0f;
  pface->V1 = (float)(pData[0].v & 0xFF)/255.0f;

  pface->I2 = pData[1].index;
  pface->U2 = (float)(pData[1].u & 0xFF)/255.0f;
  pface->V2 = (float)(pData[1].v & 0xFF)/255.0f;

  pface->I3 = pData[2].index;
  pface->U3 = (float)(pData[2].u & 0xFF)/255.0f;
  pface->V3 = (float)(pData[2].v & 0xFF)/255.0f;

  pface->SetMiscFlag(0, pDesc->nFalgs & 0xFF);

  if ((type == 0x18) || (type == 0x29))
    pface->nRenderFlags = NoTransparency;

  pList->Add(pface);
  if (pDesc->num_verts == 4)
  {
    pface->I1 = pData[0].index;
    pface->U1 = (float)(pData[0].u & 0xFF)/255.0f;
    pface->V1 = (float)(pData[0].v & 0xFF)/255.0f;
    pface->I2 = pData[2].index;
    pface->U2 = (float)(pData[2].u & 0xFF)/255.0f;
    pface->V2 = (float)(pData[2].v & 0xFF)/255.0f;
    pface->I3 = pData[3].index;
    pface->U3 = (float)(pData[3].u & 0xFF)/255.0f;
    pface->V3 = (float)(pData[3].v & 0xFF)/255.0f;
    pList->Add(pface);
  }
*/
  pface->I1 = pData[0].index;
  pface->U1 = (float)(pData[0].u & 0xffffff)/(float)(0xffffff);
  pface->V1 = (float)(pData[0].v & 0xffffff)/(float)(0xffffff);

  pface->I2 = pData[1].index;
  pface->U2 = (float)(pData[1].u & 0xffffff)/(float)(0xffffff);
  pface->V2 = (float)(pData[1].v & 0xffffff)/(float)(0xffffff);

  pface->I3 = pData[2].index;
  pface->U3 = (float)(pData[2].u & 0xffffff)/(float)(0xffffff);
  pface->V3 = (float)(pData[2].v & 0xffffff)/(float)(0xffffff);

  if ((type == 0x18) || (type == 0x29))
    pface->nRenderFlags = NoTransparency;
  else
    pface->nRenderFlags = 0;
//  if (type == 0x33)
//    AfxMessageBox("33");

  pList->Add(pface);
  if (pDesc->num_verts == 4)
  {
    pface->I1 = pData[0].index;
    pface->U1 = (float)(pData[0].u & 0xffffff)/(float)(0xffffff);
    pface->V1 = (float)(pData[0].v & 0xffffff)/(float)(0xffffff);
    pface->I2 = pData[2].index;
    pface->U2 = (float)(pData[2].u & 0xffffff)/(float)(0xffffff);
    pface->V2 = (float)(pData[2].v & 0xffffff)/(float)(0xffffff);
    pface->I3 = pData[3].index;
    pface->U3 = (float)(pData[3].u & 0xffffff)/(float)(0xffffff);
    pface->V3 = (float)(pData[3].v & 0xffffff)/(float)(0xffffff);
    pList->Add(pface);
  }
}


/**********************************************************************/
//      BIN File Importer to Zanoza 3D Editor
/**********************************************************************/
DWORD CALLBACK Import(  CString fromfile,
            CWnd *pwnd,
            tObjectSet* Objects,
            tUnDataSet* UnData,
            CDirect3D*  d3d,
            SYSTEMREQUESTPROC RequestProc,
            HINSTANCE AppHIns,
            HINSTANCE DllHIns)
{
  CFile InFile;
  if (!InFile.Open(fromfile, CFile::modeRead))
  {
    ShowFailMessage(pwnd, "Can not open the file", "Invalid file attributes", MB_ICONHAND);
    return 0;
  }

  DWORD ID;
  InFile.Read(&ID, 4);
  if (ID!=0x14)
  {
    ShowFailMessage(pwnd, "Invalid BIN file", "not the 3d-mesh BIN file", MB_ICONHAND);
    return 0;
  }
  sBinHeader header;
  InFile.Read(&header, sizeof(sBinHeader));
  
//////////////////////////////
/// Read verts; ReadNormals;
  float Scale = ((float)header.scale*0.001f)/(float)(0x10000);
  int i, j;
  sBinVert* verts    = new sBinVert[header.verts_num];
  sBinVert* norms    = NULL;
  InFile.ReadHuge(verts, sizeof(sBinVert)*header.verts_num);


  sTextureDesc  TextureDesc;
  sTextureSlides  TextureSlides;
  long curMaterial = 0;
  CString texname, MatName;
  sFaceHeader    BinFace;
  sFaceData    FaceData[4];
  FaceList    fList;
  tFace      face;
  
  tObject*  pObj = new tObject;
  strcpy(pObj->ObjectName, InFile.GetFileName());
  pObj->VertTable->VertAmount = header.verts_num;
  pObj->VertTable->Table = new tNormalVertex[header.verts_num];

  for (i = 0; i < header.verts_num; i++)
  {
    pObj->VertTable->Table[i].X = -Scale*(float)(verts[i].x);
    pObj->VertTable->Table[i].Y = Scale*(float)(verts[i].y);
    pObj->VertTable->Table[i].Z = Scale*(float)(verts[i].z);
  }



  ////////////////////////////
  // reading cicle;
  while (InFile.GetPosition() != InFile.GetLength())
  {// chunks
    InFile.Read(&ID, 4);
    switch(ID)
    {//switch
      case 0x03:
        InFile.Read(&ID, 4);//unknown = 0
        InFile.Read(&ID, 4);//amount
        if (ID != (DWORD)header.verts_num)
        {
          ShowFailMessage(pwnd, "Invalid BIN file", "Amount of normals != amount of vertices", MB_ICONHAND);
          InFile.Close();
          return 0;
        }
        norms = new sBinVert[ID];
        InFile.ReadHuge(norms, sizeof(sBinVert)*ID);
        for (i = 0; i < header.verts_num; i++)
        {
          pObj->VertTable->Table[i].NormalX = -((float)(norms[i].x)/(float)(0xFFFF));
          pObj->VertTable->Table[i].NormalY = ((float)(norms[i].y)/(float)(0xFFFF));
          pObj->VertTable->Table[i].NormalZ = ((float)(norms[i].z)/(float)(0xFFFF));
        }
        break;
      case 0x17:
        InFile.Read(&ID, 4);//unknown1 = 0
        InFile.Read(&ID, 4);//unknown2 = 0
        break;
      case 0x0D: //texture Block
        InFile.Read(&TextureDesc, sizeof(sTextureDesc));
        texname = TextureDesc.name;
        MatName = "Textured material :";
        MatName+=texname;
      case 0x1D: //animated tex
        if (ID == 0x1D)
        {
          InFile.Read(&TextureSlides, sizeof(sTextureSlides));
          char tex_name[32];
          InFile.Read((char*)&tex_name, 32);
          texname = tex_name;
          InFile.Seek((TextureSlides.num_textures-1)*32, CFile::current);
          MatName = "Animated Texture:";
          MatName+=texname;
        }
        texname = CreateBMPFromRAW(pwnd, texname);
        curMaterial = d3d->CreateMaterial(
              1.0f,
              1.0f,
              1.0f,
              1.0f,
              1.0f,
              80.0f,
              texname.GetBuffer(512),
              "",
              "",
              "",
              (char*)MatName.GetBuffer(MAX_MATERIALNAMELEN),
              0,
              D3DTOP_MODULATE ,
              D3DTOP_DISABLE,
              D3DTOP_ADD,
              D3DTOP_DISABLE,
              D3DBLEND_ONE,
              D3DBLEND_ZERO,
              3, //colorkey;
              0,
              D3DCMP_ALWAYS,
              0x00000000,
              0x00000000);
        break;

      case 0x0A: //matte material;
        DWORD col;
        InFile.Read(&col, 4);
        float r,g,b,a;
        a = (float)(col&0xFF)/256.0f;
        b = (float)((col&0xFF00)>>8)/256.0f;
        g = (float)((col&0xFF0000)>>16)/256.0f;
        r = (float)((col&0xFF000000)>>24)/256.0f;
        curMaterial = -1;
        for (j = 0; ((curMaterial == -1) && (j < d3d->Materials.MaterialsAmount)); j++)
          if ((a == d3d->Materials.Materials[j].MatRec.ambient.a) &&
            (r == d3d->Materials.Materials[j].MatRec.ambient.r) &&
            (g == d3d->Materials.Materials[j].MatRec.ambient.g) &&
            (b == d3d->Materials.Materials[j].MatRec.ambient.b))
            curMaterial = j;
        if (curMaterial == -1) //not found;
          curMaterial = d3d->CreateMaterial(
              r,
              g,
              b,
              1.0f,//dafault
              1.0f,
              80.0f,
              "",
              "",
              "",
              "",
              "Colored material",
              0,
              D3DTOP_DISABLE,
              D3DTOP_DISABLE,
              D3DTOP_DISABLE,
              D3DTOP_DISABLE,
              D3DBLEND_ONE,
              D3DBLEND_ZERO,
              0, //unused;
              0,
              D3DCMP_ALWAYS);
        break;

      case 0x0E: //faces;
      case 0x11:
      case 0x18:
      case 0x29:
      case 0x33:
      case 0x34:
        InFile.Read(&BinFace, sizeof(sFaceHeader));
        if (BinFace.num_verts == 3)
          InFile.Read(&FaceData, sizeof(sFaceData)*3);
        else
          InFile.Read(&FaceData, sizeof(sFaceData)*4);
        

        face.Material = curMaterial;
        SetFace(&face, &fList, (sFaceData*)&FaceData, &BinFace, ID);//auto add;
        break;

      case 0x19: //matte face
        InFile.Read(&BinFace, sizeof(sFaceHeader));
        for (j = 0; j < BinFace.num_verts; j++)
        {
          InFile.Read(&FaceData[j].index, 4);
          FaceData[j].u = 0;
          FaceData[j].v = 0;
        }
        face.Material = curMaterial;
        SetFace(&face, &fList, (sFaceData*)&FaceData, &BinFace, ID);//auto add;
        break;
      case 0x00: //EOF
        InFile.SeekToEnd();
        break;
      default:
        ShowFailMessage(pwnd, "Invalid BIN file", " Unknown block found in BIN file", MB_ICONHAND);
        AfxMessageBox(Int2String(InFile.GetPosition()));
        InFile.Close();
        return 0;
    }//switch
  }// chunks

  /////////////////////
  // Ok; lets init faces;
  pObj->FaceTable->FaceAmount = fList.amount;
  pObj->FaceTable->Table = new tFace[fList.amount];
  FaceListNode*  Ptr =fList. Head;
  for (i = 0; i < fList.amount; i++)
  {
    pObj->FaceTable->Table[i] = Ptr->face;
    Ptr = Ptr->next;
  }


  delete[] verts;
  if (norms)
    delete[] norms;
  else
  {//calculate normals;
    pObj->VertTable->MarkAll();
    pObj->CalculateNormals(TRUE, FALSE, /*extended:*/FALSE);
    pObj->VertTable->UnMarkAll();
  }//calculate normals;
  Objects->AddObject(pObj);
  delete pObj;

  InFile.Close();
  return 1;
}//Import



BOOL IsMaterialUsed(long index , tObject* pObj)
{
  BOOL res = FALSE;
  for (int i = 0; (!res && (i < pObj->FaceTable->FaceAmount)); i++)
    res = (pObj->FaceTable->Table[i].Material == index);

  return res;
}


/**********************************************************************/
//      File Exporter from ZModeler
/**********************************************************************/
DWORD CALLBACK Export(  CString Tofile,
            CWnd* pwnd,
            tObjectSet* Objects,
            tUnDataSet* UnData,
            CDirect3D*  d3d,
            SYSTEMREQUESTPROC RequestProc,
            HINSTANCE AppHIns,
            HINSTANCE DllHIns)
{//Export
  Objects->UnSelectAll();
  if (RequestProc)
    RequestProc(Z3D_REQUEST_SELECT_BYNAME,
          Objects,
          "Choose an Object to Export\nThe first selected object will be exported",
          NULL,
          NULL);

  int i, index;
  index = -1;
  for (i = 0; ((index == -1) && (i < Objects->ObjAmount)); i++)
    if (Objects->ObjSet[i].Selected())
      index = i;
  if ((index == -1) || (Objects->ObjAmount <= 0))
    return 0;
  ///////////////////////////////////
  // Export object #index;
  tObject* pObj = &Objects->ObjSet[index];
  CFile OutFile;
  if (!OutFile.Open(Tofile, CFile::modeWrite | CFile::modeCreate))
  {
    ShowFailMessage(pwnd, "Error rewriting file","Invalid Attributes?",MB_ICONQUESTION);
    return 0;
  }
  
  DWORD FaceNormal = 0x33;
  DWORD FaceNoTransp = 0x29;
  if (pwnd->MessageBox("Force exporting in MTM1 format instead MTM2 format?", "Exporting", MB_ICONQUESTION|MB_YESNO)==IDYES)
  {
    FaceNormal = 0x11;
    FaceNoTransp = 0x18;
  }

  DWORD ID = 0x14;
  OutFile.Write(&ID, 4);
  sBinHeader header;
  sFaceHeader BinFace;
  sFaceData  FaceData[3];
  long    MatteIndex[3];

  header.scale = 0x10000;
  header.unknown1 = 0x02;
  header.unknown2 = 0x00;
  header.verts_num = pObj->VertTable->VertAmount;
  OutFile.Write(&header, sizeof(sBinHeader));
  if (header.verts_num == 0)
  {
    OutFile.Close();
    return 0;
  }
  sBinVert* verts    = new sBinVert[header.verts_num];
  sBinVert* norms    = new sBinVert[header.verts_num];
  float scale = 1000;//1.0f/(65.536f * 65536.0f);
  for (i = 0; i < pObj->VertTable->VertAmount; i++)
  {
    verts[i].x = -(long)(scale*(pObj->VertTable->Table[i].X));
    verts[i].y = (long)(scale*(pObj->VertTable->Table[i].Y));
    verts[i].z = (long)(scale*(pObj->VertTable->Table[i].Z));
    norms[i].x = -(long)(pObj->VertTable->Table[i].NormalX*0xFFFF);
    norms[i].y = (long)(pObj->VertTable->Table[i].NormalY*0xFFFF);
    norms[i].z = (long)(pObj->VertTable->Table[i].NormalZ*0xFFFF);
  }
  OutFile.WriteHuge(verts, sizeof(sBinVert)*header.verts_num);

  ID = 0x03;//normals
  OutFile.Write(&ID, 4); ID = 0;OutFile.Write(&ID, 4);ID = header.verts_num;OutFile.Write(&ID, 4);
  OutFile.WriteHuge(norms, sizeof(sBinVert)*header.verts_num);

  float  v1x,v1y,v1z,v2x,v2y,v2z,v3x,v3y,v3z,
      ax,ay,az,bx,by,bz,cx,cy,cz;
  double  len,factor;

  for (long count = 0; count < d3d->Materials.MaterialsAmount; count++)
    if (IsMaterialUsed(count, pObj))
    {//write these faces
      BOOL bMatte;
      if (d3d->Materials.Materials[count].MatParams.PrimTexture >= 0)
      {//textured
        ID = 0x0D;//texture
        OutFile.Write(&ID, 4);
        sTextureDesc TextureDesc;
        TextureDesc.unknown1 = 0;
        strcpy(TextureDesc.name, "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0");
        strcpy(TextureDesc.name, d3d->Materials.Textures->GetName(d3d->Materials.Materials[count].MatParams.PrimTexture));
        int pos = CString(TextureDesc.name).Find('.');
        if (pos > 0)
          strcpy((char*)&TextureDesc.name[pos], ".RAW\0");

        OutFile.Write(&TextureDesc, sizeof(sTextureDesc));
        bMatte = FALSE;
      }//textured
      else
      {//matte
        ID = 0x0A;//matte
        OutFile.Write(&ID, 4);
        DWORD color = 0;
        color = ((DWORD)(d3d->Materials.Materials[count].MatRec.ambient.a*255))+
            (((DWORD)(d3d->Materials.Materials[count].MatRec.ambient.b*255))<<8)+
            (((DWORD)(d3d->Materials.Materials[count].MatRec.ambient.g*255))<<16)+
            (((DWORD)(d3d->Materials.Materials[count].MatRec.ambient.r*255))<<24);
        OutFile.Write(&color, 4);
        bMatte = TRUE;
      }//matte
      ////////////////////
      // write faces now;
      for (i = 0; i < pObj->FaceTable->FaceAmount; i++)
        if (pObj->FaceTable->Table[i].Material == count)
        {//write this face
          if (pObj->FaceTable->Table[i].nRenderFlags & NoTransparency)
            ID = FaceNoTransp;
          else
            ID = FaceNormal;
          if (bMatte)
            ID = 0x19;
          OutFile.Write(&ID, 4);
          v1x = -pObj->VertTable->Table[pObj->FaceTable->Table[i].I1].X/scale;
          v1y = pObj->VertTable->Table[pObj->FaceTable->Table[i].I1].Y/scale;
          v1z = pObj->VertTable->Table[pObj->FaceTable->Table[i].I1].Z/scale;
          v2x = -pObj->VertTable->Table[pObj->FaceTable->Table[i].I2].X/scale;
          v2y = pObj->VertTable->Table[pObj->FaceTable->Table[i].I2].Y/scale;
          v2z = pObj->VertTable->Table[pObj->FaceTable->Table[i].I2].Z/scale;
          v3x = -pObj->VertTable->Table[pObj->FaceTable->Table[i].I3].X/scale;
          v3y = pObj->VertTable->Table[pObj->FaceTable->Table[i].I3].Y/scale;
          v3z = pObj->VertTable->Table[pObj->FaceTable->Table[i].I3].Z/scale;

          ax=(v2x-v1x);
          ay=(v2y-v1y);
          az=(v2z-v1z);

          bx=(v3x-v1x);
          by=(v3y-v1y);
          bz=(v3z-v1z);

          cx = ay*bz - az*by;
          cy = az*bx - ax*bz;
          cz = ax*by - ay*bx;
          len = pow(cx*cx+cy*cy+cz*cz, 0.5);
          factor = 65535.0f/len;
        
          BinFace.normal_x = (long)(factor*cx);
          BinFace.normal_y = (long)(factor*cy);
          BinFace.normal_z = (long)(factor*cz);

          BinFace.nFalgs = (long)(BinFace.normal_x*v1x + BinFace.normal_y*v1y + BinFace.normal_z*v1z);

          BinFace.num_verts = 3;
          OutFile.Write(&BinFace, sizeof(sFaceHeader));
          if (bMatte)
          {
            MatteIndex[0] = pObj->FaceTable->Table[i].I1;
            MatteIndex[1] = pObj->FaceTable->Table[i].I2;
            MatteIndex[2] = pObj->FaceTable->Table[i].I3;
            OutFile.Write(&MatteIndex, 12);
          }
          else
          {
            FaceData[0].index = pObj->FaceTable->Table[i].I1;
            FaceData[0].u = (DWORD)(pObj->FaceTable->Table[i].U1*0xFFFFFF);
            FaceData[0].v = (DWORD)(pObj->FaceTable->Table[i].V1*0xFFFFFF);
            FaceData[1].index = pObj->FaceTable->Table[i].I2;
            FaceData[1].u = (DWORD)(pObj->FaceTable->Table[i].U2*0xFFFFFF);
            FaceData[1].v = (DWORD)(pObj->FaceTable->Table[i].V2*0xFFFFFF);
            FaceData[2].index = pObj->FaceTable->Table[i].I3;
            FaceData[2].u = (DWORD)(pObj->FaceTable->Table[i].U3*0xFFFFFF);
            FaceData[2].v = (DWORD)(pObj->FaceTable->Table[i].V3*0xFFFFFF);
            OutFile.Write(&FaceData, sizeof(sFaceData)*3);
          }
        }//write this face
    }//write these material faces;
  
  ID = 0;  //EOF
  OutFile.Write(&ID, 4);
  ///////////////////////////////////
  // Export object #index;

  Objects->UnSelectAll();
  OutFile.Close();
  return Z3D_PLUGRESULT_SELECTIONCHANGED;
}//Export




